DROP PROCEDURE [hips].[HospitalAddressGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date:   23 November 2012
-- Description:   Gets a list of addresses for a specified hospital.
-- Modified:
-- Philip Stalley-Gordon -  3 April 2013 - Make HospitalId optional and return HospitalId
-- =============================================
CREATE PROCEDURE [hips].[HospitalAddressGet] 
(
	   @HospitalId INT = NULL
) AS
BEGIN
SELECT DISTINCT
		a.AddressId,
		a.AddressLine1,
		a.AddressLine2,
		a.PlaceName,
		a.AustralianStateId,
		st.Code AS AustralianStateCode,
		st.Description AS AustralianStateName,
		a.InternationalStateCode,
		a.PostCode,
		a.CountryId,
		c.Description AS CountryName,
		a.AddressTypeId,
		at.Description AS AddressTypeDescription,
		a.DateCreated,
		a.UserCreated,
		a.DateModified,
		a.UserModified,
		ha.HospitalId
FROM hips.HospitalAddress ha
INNER JOIN hips.Address a on ha.AddressId = a.AddressId
INNER JOIN hips.Country AS c ON c.CountryId = a.CountryId
INNER JOIN hips.AddressType AS at ON at.AddressTypeId = a.AddressTypeId
LEFT OUTER JOIN hips.State AS st ON st.StateID = a.AustralianStateId
WHERE (@HospitalId IS NULL OR ha.HospitalId = @HospitalId)

END
GO

